<?php
// ++=========================================================================++
// || vBadvanced Gallery v1.0 RC2
// ||              
// ||             .
// ||       (  )
// || tranlated by: arabsdesign.com
// || www.arabsdesign.com
// ++ ========================================================================++

error_reporting(E_ALL & ~E_NOTICE);
define('NO_REGISTER_GLOBALS', 1);
define('THIS_SCRIPT', 'gallery_index');

$globaltemplates = array(
	'ADV_GALLERY',
	'adv_gallery_categorybit_level1',
	'adv_gallery_categorybit_level2',
	'adv_gallery_categorybit_main',
	'adv_gallery_imagebit',
	'forumhome_moderator'
);

$phrasegroups = array();

$specialtemplates = array();

require_once('./gallery_global.php');

// Get category info to print the categories and make the stats
$getcats = $DB_site->query("
		SELECT catid, title, description, hasimages, active, parent, parentlist, catimage, imagecount, postcount, catuserid, useroptions, lastimageid, lastimagetitle, lastimageuserid, lastimageusername, lastimagedateline, lastpostid, lastpostuserid, lastpostusername, lastpostimagetitle, lastpostdateline
		FROM " . TABLE_PREFIX ."adv_gallery_categories
		ORDER BY displayorder ASC, hasimages
");
while ($categories = $DB_site->fetch_array($getcats))
{
	$catinfo["$categories[catid]"] = $categories;
}

$DB_site->free_result($getcats);
unset($categories);

if ($vba_options['gallery_allowreplies'])
{
	$show['replycells'] = true;
	$stylevar['imagecount'] = 'alt2';
	$stylevar['moderator'] = 'alt2';
}
else
{
	$stylevar['imagecount'] = 'alt1';
	$stylevar['moderator'] = 'alt2';
}

// Print the categories
$categorybits = print_categories(intval($catid), $catinfo);

if (!$catid)
{
	$show['directoryhead'] = true;
	$show['stats'] = true;

	// Sort out the stats
	$stats['categories'] = 0;
	$stats['images'] = 0;
	$stats['posts'] = 0;

	if (is_array($catinfo))
	{
		foreach ($catinfo AS $count)
		{
			$stats['categories']++;
			$stats['images'] += $count['imagecount'];
			$stats['posts'] += $count['postcount'];
		}

		$stats['categories'] = number_format($stats['categories']);
		$stats['images'] = number_format($stats['images']);
		$stats['posts'] = number_format($stats['posts']);
	}

	$getstats = $DB_site->query_first("SELECT SUM(views) AS views, SUM(filesize) AS filesize " . iif($vba_options['gallery_saveoriginal'], ', SUM(originalfilesize) AS origfilesize') . " FROM " . TABLE_PREFIX . "adv_gallery_images WHERE valid = 1");
	$stats['views'] = number_format($getstats['views']);
	$stats['diskspace'] = make_good_size($getstats['filesize'] + $getstats['origfilesize']);

	$show['category'] = true;

	if ($vba_options['gallery_newhomeimages'] OR $vba_options['gallery_randomhomeimages'])
	{
		require_once('./includes/functions_bbcodeparse.php');
		$query = fetch_image_fields();
		$cellwidth = round(100 / $vba_options['gallery_columns']) . '%';
		if ($privatecatids = fetch_private_categories())
		{
			$privcatids = 'images.catid NOT IN(' . $privatecatids . ') AND ';
		}
	}

	// Newest images
	if ($vba_options['gallery_newhomeimages'])
	{
		$show['newimages'] = true;
		$counter = 0;
		$getnew = $DB_site->query("
				SELECT imageid, images.title, filename, thumbname, extension, images.catid $query[fields]
				FROM " . TABLE_PREFIX . "adv_gallery_images AS images
				$query[tables]
				WHERE $privcatids valid = 1
				ORDER BY dateline DESC
				LIMIT $vba_options[gallery_newhomeimages]
		");
		if ($DB_site->num_rows($getnew))
		{
			while ($images = $DB_site->fetch_array($getnew))
			{
				$counter++;
				$newimagebits .= construct_imagebits($images);
			}

			$newimagebits .= construct_empty_imagebits();
		}
		else
		{
			eval('$newimagebits = "' . fetch_template('adv_gallery_nodisplay') . '";');
		}
		$DB_site->free_result($getnew);
		unset($images);
	}

	// Random images
	if ($vba_options['gallery_randomhomeimages'])
	{
		$show['randomimages'] = true;
		$counter = 0;
		$getrand = $DB_site->query("
				SELECT imageid, images.title, filename, thumbname, extension, images.catid $query[fields]
				FROM " . TABLE_PREFIX . "adv_gallery_images AS images
				$query[tables]
				WHERE $privcatids valid = 1
				ORDER BY RAND()
				LIMIT $vba_options[gallery_randomhomeimages]
		");
		if ($DB_site->num_rows($getrand))
		{
			while ($images = $DB_site->fetch_array($getrand))
			{
				$counter++;
				$randomimagebits .= construct_imagebits($images);
			}

			$randomimagebits .= construct_empty_imagebits();
		}
		else
		{
			eval('$randomimagebits = "' . fetch_template('adv_gallery_nodisplay') . '";');
		}
		$DB_site->free_result($getrand);
		unset($images);
	}

	if ($vba_options['gallery_navbarhomelink'])
	{
		$navbits[''] = $vba_options['gallery_title'];
	}
	$navbar = construct_adv_navbar($navbits);

}
else
{
	$show['subcats'] = true;
	$categoryjump = print_category_jump($catid);

	foreach ($catinfo AS $navcat)
	{
		if ($navcat['catid'] == $catid)
		{
			$navinfo['title'] = stripslashes($navcat['title']);
			$navinfo['parentlist'] = $navcat['parentlist'];
		}
	}

	if ($vba_options['gallery_navbarhomelink'])
	{
		$navbits["$vba_options[gallery_url]"] = $vba_options['gallery_title'];
	}
	$navbits = construct_dir_navbits($navinfo['parentlist']);
	$navbar = construct_adv_navbar($navbits);
}

if (defined('VBA_PORTAL'))
{
	eval('$HTML .= "' . fetch_template('ADV_GALLERY') . '";');
	print_portal_output($home, $HTML);
}
else
{
	eval('print_output("' . fetch_template('ADV_GALLERY') . '");');
}

?>